<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="includes/banshee.xslt" />

<!--
//
//  Referers template
//
//-->
<xsl:template match="referers">
<xsl:for-each select="hostname">
	<fieldset class="host">
	<legend><xsl:value-of select="@name" /></legend>
	<div class="total">Total: <xsl:value-of select="@count" /></div>
	<xsl:for-each select="referer">
		<div class="referer">
		<div class="count"><xsl:value-of select="@count" /></div>
		<div class="link"><a href="{.}" target="_blank"><xsl:value-of select="." /></a></div>
		</div>
	</xsl:for-each>
	</fieldset>
</xsl:for-each>
</xsl:template>

<!--
//
//  Result template
//
//-->
<xsl:template match="result">
<p><xsl:value-of select="." /></p>
<xsl:choose>
	<xsl:when test="@url">
		<xsl:call-template name="redirect"><xsl:with-param name="url" select="@url" /></xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="redirect" />
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--
//
//  Content template
//
//-->
<xsl:template match="content">
<h1>Referers</h1>
<xsl:apply-templates select="filter" />
<xsl:apply-templates select="referers" />
<xsl:apply-templates select="result" />
</xsl:template>

</xsl:stylesheet>
