<?xml version="1.0" ?>
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:include href="includes/banshee.xslt" />

<!--
//
//  Statistics template
//
//-->
<xsl:template match="statistics">
<table class="list">
<tr>
	<th>Webserver</th>
	<th>Timestamp begin</th>
	<th>Timestamp end</th>
	<th>Simultaneous connections</th>
</tr>
<xsl:for-each select="connections/connection">
<tr>
	<td><xsl:value-of select="name" /></td>
	<td><xsl:value-of select="timestamp_begin" /></td>
	<td><xsl:value-of select="timestamp_end" /></td>
	<td><xsl:value-of select="simult_conns" /></td>
</tr>
</xsl:for-each>
</table>
</xsl:template>

<!--
//
//  Result template
//
//-->
<xsl:template match="result">
<p><xsl:value-of select="." /></p>
<xsl:choose>
	<xsl:when test="@url">
		<xsl:call-template name="redirect"><xsl:with-param name="url" select="@url" /></xsl:call-template>
	</xsl:when>
	<xsl:otherwise>
		<xsl:call-template name="redirect" />
	</xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--
//
//  Content template
//
//-->
<xsl:template match="content">
<h1>Server statistics</h1>
<xsl:apply-templates select="statistics" />
<xsl:apply-templates select="result" />
</xsl:template>

</xsl:stylesheet>
