<?php
	class actions_controller extends controller {
		public function execute() {
			if (($actions = $this->model->get_actions()) === false) {
				$this->output->add_tag("result", "Database error.");
				return;
			}

			$webserver = null;
			$this->output->open_tag("actions");
			foreach ($actions as $action) {
				if ($action["name"] != $webserver) {
					if ($webserver !== null) {
						$this->output->close_tag();
					}
					$webserver = $action["name"];
					$this->output->open_tag("webserver", array("name" => $webserver));
				}

				$timestamp = date("j F Y, H:i:s", $action["timestamp"]);
				$this->output->add_tag("action", $action["action"], array("timestamp" => $timestamp));
			}
			if ($webserver !== null) {
				$this->output->close_tag();
			}
			$this->output->close_tag();
		}
	}
?>
