<?php
	define("PIXELS", 200);
	class host_statistics_controller extends controller {
		public function execute() {
			$filter = new filter($this->db, $this->output);
			$filter->to_output("host_statistics");

			$begin = date("Y-m-d", strtotime("-".MONITOR_DAYS." days"));
			$end = date("Y-m-d", strtotime("tomorrow"));

			if (($statistics = $this->model->get_statistics($begin, $end, $filter->hostname, $filter->webserver)) === false) {
				$this->output("result", "Database error.");
				return;
			}

			$graphs = array(
				"requests"              => "Requests",
				"bytes_sent"            => "Bytes sent",
				"bans"                  => "Clients banned",
				"exploit_attempts"      => "Exploit attempts",
				"result_forbidden"      => "Result: 403 Forbidden",
				"result_not_found"      => "Result: 404 Not Found",
				"result_internal_error" => "Result: 500 Internal Server Error");

			$this->output->open_tag("graphs", array(
				"begin" => date("j F Y", strtotime($begin)),
				"end"   => date("j F Y", strtotime($end) - DAY)));

			foreach ($graphs as $key => $label) {
				$max = 0;
				foreach ($statistics as $day => $record) {
					if ($record[$key] > $max) {
						$max = $record[$key];
					}
				}

				$this->output->open_tag("graph", array(
					"label" => $label,
					"max"   => $this->model->readable_number($max)));

				foreach ($statistics as $day => $record) {
					$value = ($max == 0) ? 0 : (int)(PIXELS * $record[$key] / $max) + 1;
					$day = date("j F", strtotime($day));
					$this->output->add_tag("day", $value, array(
						"label" => $day,
						"count" => $this->model->readable_number($record[$key])));
				}

				$this->output->close_tag();
			}

			$this->output->close_tag();
		}
	}
?>
