<?php
	class referers_controller extends controller {
		public function execute() {
			$filter = new filter($this->db, $this->output);
			$filter->to_output("requests");

			$begin = date("Y-m-d", strtotime("-30 day"));
			$end = date("Y-m-d", strtotime("tomorrow"));

			if (($referers = $this->model->get_referers($begin, $end, $filter->hostname, $filter->webserver)) === false) {	
				$this->output->add_tag("result", "Database error.");
				return;
			}

			$this->output->open_tag("referers");
			foreach ($referers["hostnames"] as $hostname => $count) {
				$to_output = false;

				foreach ($referers["referers"][$hostname] as $referer) {
					if ($referer["count"] < REFERER_MIN_COUNT) {
						continue;
					}

					if ($to_output == false) {
						$this->output->open_tag("hostname", array("name" => $hostname, "count" => $count));
						$to_output = true;
					}

					$this->output->add_tag("referer", $referer["referer"], array("count" => $referer["count"]));
				}

				if ($to_output) {
					$this->output->close_tag();
				}
			}
			$this->output->close_tag();
		}
	}
?>
