<?php
	class admin_file_model extends model {
		public function filename_oke($file) {	
			$info = pathinfo($file);

			if ($file != $info["basename"]) {
				return false;
			}

			if ($file[0] == ".") {
				return false;
			}

			return true;
		}

		public function directory_listing($directory) {
			if (($dp = opendir($directory)) == false) {
				return false;
			}

			$files = array();
			while (($file = readdir($dp)) !== false) {
				if (($file[0] != ".") && (is_dir($directory."/".$file) == false)) {
					array_push($files, $file);
				}
			}

			closedir($dp);

			sort($files);

			return $files;
		}

		public function get_file_size($file) {
			if (($size = filesize($file)) === false) {
				return false;
			}

			if ($size > 1048576) {
				return sprintf("%.2f MB", $size / 1048576);
			} else if ($size > 1024) {
				return sprintf("%.2f kB", $size / 1024);
			}

			return $size." byte";
		}

		public function upload_oke($file) {
			global $allowed_uploads;

			if ($file["error"] !== 0) {
				$this->output->add_message("Error while uploading file.");
				return false;
			}

			if (filename_oke($file["name"]) == false) {
				$this->output->add_message("Invalid filename.");
				return false;
			}
			if (($ext = strrchr($file["name"], ".")) === false) {
				$this->output->add_message("File has no extension.");
				return false;
			}
			if (in_array(substr($ext, 1), $allowed_uploads) == false) {
				$this->output->add_message("Invalid file extension.");
				return false;
			}
			if (file_exists(UPLOAD_DIRECTORY."/".$file["name"])) {
				$this->output->add_message("File already exists.");
				return false;
			}

			return true;
		}

		public function import_uploaded_file($file) {
			return move_uploaded_file($file["tmp_name"], UPLOAD_DIRECTORY."/".$file["name"]);
		}

		public function delete_file($file) {
			if (filename_oke($file) == false) {	
				return false;
			}

			return unlink(UPLOAD_DIRECTORY."/".$file);
		}
	}
?>
