<?php
	class actions_controller extends controller {
		public function execute() {
			if (($count = $this->model->count_actions()) === false) {
				$this->output->add_tag("result", "Database error.");
				return;
			}

			$paging = new pagination($this->output, "actions", $this->settings->action_page_size, $count);

			if (($actions = $this->model->get_actions($paging->offset, $paging->size)) === false) {
				$this->output->add_tag("result", "Database error.");
				return;
			}

			$this->output->open_tag("actions");

			foreach ($actions as $action) {
				$action["timestamp"] = date("j F Y, H:i:s", $action["timestamp"]);
				$this->output->record($action, "action");
			}

			$paging->show_browse_links();

			$this->output->close_tag();
		}
	}
?>
