<?php
	/* public/index.php
	 *
	 * Copyright (C) by Hugo Leisink <hugo@leisink.net>
	 * This file is part of the Banshee PHP framework
	 * http://www.banshee-php.org/
	 *
	 * Don't change this file, unless you know what you are doing.
	 */

	ob_start();
	require("../libraries/error.php");
	require("../libraries/configuration.php");
	require("../libraries/security.php");
	require("../libraries/general.php");

	/* Abort on dangerous PHP settings
	 */
	check_PHP_setting("register_globals", 0);
	check_PHP_setting("allow_url_include", 0);

	/* Undo magic quotes
	 */
	if (ini_get("magic_quotes_gpc") == 1) {
		$superglobals = array(&$_REQUEST, &$_GET, &$_POST, &$_COOKIE);
		foreach ($superglobals as &$superglobal) {
			$superglobal = remove_magic_quotes($superglobal);
		}
	}

	/* Load core modules
	 */
	$_database = new MySQLi_connection(DB_HOSTNAME, DB_DATABASE, DB_USERNAME, DB_PASSWORD);
	$_session  = new session($_database);
	$_settings = new settings($_database);
	$_user     = new user($_database, $_settings, $_session);
	$_page     = new page($_database, $_settings, $_user);
	$_output   = new output($_database, $_settings, $_page);

	/* Include the model
	 */
	if (file_exists($file = "../models/".$_page->module.".php")) {
		include($file);
	}

	$_output->open_tag("output", array("url" => $_page->url));

	if ($_page->ajax_request == false) {
		$_output->add_tag("banshee_version", BANSHEE_VERSION);
		$_output->add_tag("monitor_version", MONITOR_VERSION);
		$_output->add_tag("website_url", $_SERVER["SERVER_NAME"]);

		/* Page information
		 */
		$_output->add_tag("page", $_page->page, array(
			"module" => $_page->module,
			"type"   => $_page->type));

		/* User information
		 */
		if ($_user->logged_in) {
			$params = array("id" => $_user->id, "admin" => show_boolean($_user->is_admin));
			$_output->add_tag("user", $_user->fullname, $params);
		}

		/* Main menu
		 */
		if (is_true(WEBSITE_ONLINE)) {
			if ($_output->fetch_from_cache("menu") == false) {
				$_output->start_caching("menu");
				$menu = new menu($_database, $_output);
				$menu->to_output(0, 2, $_page->page);
				$_output->stop_caching();
			}
		}

		/* Stylesheet
		 */
		$_output->add_css($_page->module.".css");

		/* Old browser notification
		 */
		if (preg_match("/MSIE [123456]/", $_SERVER["HTTP_USER_AGENT"]) > 0) {
			if ($_SESSION["old_browser"] != 1) {
				$_SESSION["old_browser"] = 1;
				$_output->add_css("includes/old_browser.css");
				$_output->add_tag("old_browser");
			}
		}

		$_output->open_tag("content");
	}

	/* Include the controller
	 */
	if (file_exists($file = "../controllers/".$_page->module.".php")) {
		include($file);

		$controller_class = str_replace("/", "_", $_page->module)."_controller";
		if (class_exists($controller_class) == false) {
			print "Controller class '".$controller_class."' does not exist.\n";
		} else if (is_subclass_of($controller_class, "controller") == false) {
			print "Controller class '".$controller_class."' does not extend 'controller'.\n";
		} else {
			$_controller = new $controller_class($_database, $_settings, $_user, $_page, $_output);
			$_controller->execute();
			unset($_controller);
		}
	}

	if ($_page->ajax_request == false) {
		$_output->close_tag();
	}

	/* Errors
	 */
	$errors = ob_get_contents();
	ob_end_clean();

	if ($errors != "") {
		$error_handler = new website_error_handler($_output, $_settings);
		$error_handler->execute($errors);
		unset($error_handler);
	}

	/* Close output
	 */
	$_output->close_tag();

	/* Output content
	 */
	$_output->generate($_GET["output"], $_page->view);
?>
