/* sandbox.h -- OS-level sandboxing for Hiawatha
 *
 * Supports: OpenBSD (pledge/unveil), Linux (landlock/seccomp),
 *           macOS (Seatbelt), others (no-op with warning).
 *
 * Defense-in-depth: sandbox errors are never fatal.
 */

#ifndef _SANDBOX_H
#define _SANDBOX_H

#ifdef ENABLE_SANDBOX

#include "serverconfig.h"

/* Phase 1: Collect filesystem paths from parsed config.
 * Call after read_main_configfile(), before privilege drop.
 * Returns 0 on success, -1 on error (logged, non-fatal).
 */
int sandbox_collect_paths(t_config *config);

/* Phase 2: Apply OS sandbox restrictions.
 * Call after change_uid_gid() / privilege drop.
 * Returns 0 on success, -1 on error (logged, non-fatal).
 */
int sandbox_apply(void);

/* Print collected sandbox paths (for -V output).
*/
void sandbox_print_paths(void);

#endif

#endif
