#ifndef _COMMAND_H
#define _COMMAND_H

#include "serverconfig.h"

#define cc_OKE            0
#define cc_DISCONNECT     1

#define COUNTER_CLIENT    0
#define COUNTER_FILE      1
#define COUNTER_CGI       2
#define COUNTER_INDEX     3
#define COUNTER_BAN       4
#define COUNTER_DENY      5
#define COUNTER_MAX       6

#define TRANSFER_SEND     0
#define TRANSFER_RECEIVED 1
#define TRANSFER_MAX      2

typedef struct type_admin {
	int socket;
	FILE *fp;
	bool authenticated;
	int timer;

	struct type_admin *next;
} t_admin;

void increment_counter(int counter);
void increment_transfer(int counter, long bytes);

void init_command_module(void);
int add_admin(int sock);
void remove_admin(int sock);
void check_admin_list(void);
t_admin *first_admin(void);
t_admin *next_admin(void);
int handle_admin(t_admin *admin, t_config *config);
void disconnect_admins(void);

#endif
