#ifndef _LIBIP_H
#define _LIBIP_H

#include <stdbool.h>
#include <arpa/inet.h>
#ifdef HAVE_NETINET_IN_H
#include <netinet/in.h>
#endif

#define IPv4_LEN sizeof(struct in_addr)
#ifdef HAVE_IPV6
#define IPv6_LEN sizeof(struct in6_addr)
#define MAX_IP_LEN IPv6_LEN
#define MAX_IP_STR_LEN INET6_ADDRSTRLEN
#else
#define MAX_IP_LEN IPv4_LEN
#define MAX_IP_STR_LEN INET_ADDRSTRLEN
#endif

typedef unsigned long t_ipv4;

typedef struct {
	int  family;
	char value[MAX_IP_LEN];
	int  size;
} t_ip_addr;

int  default_ipv4(t_ip_addr *ip_addr);
#ifdef HAVE_IPV6
int  default_ipv6(t_ip_addr *ip_addr);
#endif
int  set_to_localhost(t_ip_addr *ip_addr);
int  parse_ip(char *str, t_ip_addr *ip_addr);
unsigned char index_by_ip(t_ip_addr *ip);
int  copy_ip(t_ip_addr *dest, t_ip_addr *src);
bool same_ip(t_ip_addr *ip1, t_ip_addr *ip2);
int  apply_netmask(t_ip_addr *ip, int mask);
bool ip_in_subnet(t_ip_addr *ip, t_ip_addr *subnet, int mask);

#endif
